`timescale 100ps / 10ps

/*
 * Options for modeling byte transmission (uncomment at most 1)
 * - SUHDCHK_ZHD
 *   - Line is released (data=HiZ) after hold time
 * - SUHDCK_CKFE
 *   - Data is set during falling edge of CLK, line released at falling edge
 *     of CLK
 * - default (no option uncommented)
 *   - Data is set to 0 after hold time, line released (tCL-tSU) after
 *     last falling edge of CLK
 *
 */
//`define SUHDCHK_ZHD
`define SUHDCHK_CKFE

module stimulus 
	(
    IO,
    CLK1,
    CLK2,
		CS1n,
		CS2n,
    HBP,
    HTBSEL
	);

  inout [7:0] IO;
	
	output CS1n, CS2n;
	output CLK1, CLK2;
  output reg [2:0] HBP = 3'b000;
  output reg HTBSEL = 0;
        
	reg CSn = 1;
	reg CLK = 0;
        
	reg SI_IO0_reg=0;
  reg SO_IO1_reg=0;
  reg WPn_IO2_reg=0;
  reg IO3_reg=0;

  reg [3:0] tx;
  reg sel_dev;

  parameter SPI = 3'h1;
  parameter DPI = 3'h2;
  parameter QPI = 3'h4;

  wire SI_IO0;
  wire SO_IO1;
  wire WPn_IO2;
  wire IO3;

  /* Register Addresses */
  localparam ADDR_SR  = 32'h0;
  localparam ADDR_ISR = 32'h1;
  localparam ADDR_CR1 = 32'h2;
  localparam ADDR_CR2 = 32'h3;
  localparam ADDR_INTCR = 32'h4;
  localparam ADDR_ECCDIR = 32'h5;
  localparam ADDR_ECCEIR = 32'h6;
  localparam ADDR_ECCDOR = 32'h7;
  localparam ADDR_ECCECR = 32'h8;
  localparam ADDR_ID  = 32'h30;
  localparam ADDR_UID = 32'h40;
  localparam ADDR_SN  = 32'h50;

  `include "task.v"
  
  assign IO[0] = (tx[0] && sel_dev==1'b0) ? SI_IO0_reg : 1'bz;  
  assign IO[1] = (tx[1] && sel_dev==1'b0) ? SO_IO1_reg : 1'bz;  
  assign IO[2] = (tx[2] && sel_dev==1'b0) ? WPn_IO2_reg : 1'bz;  
  assign IO[3] = (tx[3] && sel_dev==1'b0) ? IO3_reg : 1'bz;  
  assign IO[4] = (tx[0] && sel_dev==1'b1) ? SI_IO0_reg : 1'bz;  
  assign IO[5] = (tx[1] && sel_dev==1'b1) ? SO_IO1_reg : 1'bz;  
  assign IO[6] = (tx[2] && sel_dev==1'b1) ? WPn_IO2_reg : 1'bz;  
  assign IO[7] = (tx[3] && sel_dev==1'b1) ? IO3_reg : 1'bz;  
  assign CLK1 = (sel_dev==1'b0) ? CLK : 0;
  assign CLK2 = (sel_dev==1'b1) ? CLK : 0;
  assign CS1n = (sel_dev==1'b0) ? CSn : 1'b1;
  assign CS2n = (sel_dev==1'b1) ? CSn : 1'b1;

  assign SI_IO0  = (sel_dev == 1'b0) ? IO[0] : IO[4];
  assign SO_IO1  = (sel_dev == 1'b0) ? IO[1] : IO[5];
  assign WPn_IO2 = (sel_dev == 1'b0) ? IO[2] : IO[6];
  assign IO3     = (sel_dev == 1'b0) ? IO[3] : IO[7];

  /* Initialize */
  initial begin
    SI_IO0_reg = 0;
    SO_IO1_reg = 0;
    WPn_IO2_reg = 0;
    IO3_reg = 0;
    tx = 0;
  end

  /* Expected errors : 2 */
  initial begin

    $display("==== [TEST] DRFW 1-1-1 ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00); // Normal wrens
    WriteEnable(SPI);
    DDRFastWriteSeq(SPI, 32'h123, 8'h32, 8'h7, 24'd10, 1'b0, 8'hff);
    ReadSeq(SPI, 32'h123, 8'h32, 8'h7, 24'd10);

    $display("==== [TEST] DRFW 1-1-1 XIP ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h01); // SRAM mode 
    WriteEnable(SPI);
    DDRFastWriteSeq(SPI, 32'h3400, 8'h40, 8'h1, 24'd3, 1'b0, 8'haf);
    DDRFastWriteSeq(SPI, 32'h3403, 8'h43, 8'h1, 24'd3, 1'b1, 8'ha0);
    DDRFastWriteSeq(SPI, 32'h3406, 8'h46, 8'h1, 24'd3, 1'b1, 8'hf0);
    DDRFastWriteSeq(SPI, 32'h3409, 8'h49, 8'h1, 24'd3, 1'b0, 8'hf0);
    ReadSeq(SPI, 32'h3400, 8'h40, 8'h1, 24'd12);

    $display("==== [TEST] DWQO 1-4-4 ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h00); // Normal wrens
    WriteEnable(SPI);
    DDRWriteQuadIOSeqXIP(SPI, 32'h321, 8'h32, 8'h7, 24'd10, 1'b0, 8'hff);
    ReadSeq(SPI, 32'h321, 8'h32, 8'h7, 24'd10);

    $display("==== [TEST] DWQO 1-4-4 XIP ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h01); // SRAM mode 
    WriteEnable(SPI);
    DDRWriteQuadIOSeqXIP(SPI, 32'h6700, 8'h40, 8'h1, 24'd3, 1'b0, 8'haf);
    DDRWriteQuadIOSeqXIP(SPI, 32'h6703, 8'h43, 8'h1, 24'd3, 1'b1, 8'ha0);
    DDRWriteQuadIOSeqXIP(SPI, 32'h6706, 8'h46, 8'h1, 24'd3, 1'b1, 8'hf0);
    DDRWriteQuadIOSeqXIP(SPI, 32'h6709, 8'h49, 8'h1, 24'd3, 1'b0, 8'hf0);
    ReadSeq(SPI, 32'h6700, 8'h40, 8'h1, 24'd12);

    $display("==== [TEST] DRFR 1-1-1 XIP ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h01); // SRAM mode 
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h0c); // Latency 12
    DDRWriteQuadIOSeqXIP(SPI, 32'hab10, 8'h50, 8'h1, 24'd12, 1'b0, 8'hff);
    DDRFastReadSeqXIP(SPI, 32'hab10, 8'h50, 8'h1, 8'hc, 24'd3, 1'b0, 8'haf);
    DDRFastReadSeqXIP(SPI, 32'hab13, 8'h53, 8'h1, 8'hc, 24'd3, 1'b1, 8'ha7);
    DDRFastReadSeqXIP(SPI, 32'hab16, 8'h56, 8'h1, 8'hc, 24'd3, 1'b1, 8'hf7);
    DDRFastReadSeqXIP(SPI, 32'hab19, 8'h59, 8'h1, 8'hc, 24'd3, 1'b0, 8'hf0);
    $display("==== [SUBTEST] DRFR 4-4-4 XIP ====");
    QPIEnable(SPI);
    DDRFastReadSeqXIP(QPI, 32'hab10, 8'h50, 8'h1, 8'hc, 24'd3, 1'b0, 8'haf);
    DDRFastReadSeqXIP(QPI, 32'hab13, 8'h53, 8'h1, 8'hc, 24'd2, 1'b1, 8'ha7);
    DDRFastReadSeqXIP(QPI, 32'hab15, 8'h55, 8'h1, 8'hc, 24'd4, 1'b1, 8'hf7);
    DDRFastReadSeqXIP(QPI, 32'hab19, 8'h59, 8'h1, 8'hc, 24'd3, 1'b0, 8'hf0);
    SPIEnable(QPI);

    $display("==== [TEST] DRQI 1-4-4 XIP ====");
    sel_dev = 0;
    WriteEnable(SPI);
    WriteStatus(SPI, 8'h00);
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR1, 8'h01); // SRAM mode 
    WriteEnable(SPI);
    WriteReg(SPI, ADDR_CR2, 8'h0c); // Latency 12
    DDRWriteQuadIOSeqXIP(SPI, 32'hd410, 8'hd0, 8'h1, 24'd12, 1'b0, 8'hff);
    DDRReadQuadIOSeqXIP(SPI, 32'hd410, 8'hd0, 8'h1, 8'hc, 24'd3, 1'b0, 8'haf);
    DDRReadQuadIOSeqXIP(SPI, 32'hd413, 8'hd3, 8'h1, 8'hc, 24'd3, 1'b1, 8'ha7);
    DDRReadQuadIOSeqXIP(SPI, 32'hd416, 8'hd6, 8'h1, 8'hc, 24'd3, 1'b1, 8'hf7);
    DDRReadQuadIOSeqXIP(SPI, 32'hd419, 8'hd9, 8'h1, 8'hc, 24'd3, 1'b0, 8'hf0);

    $finish;

  end
endmodule
